%% One-bit MIMO channel estimation based on Bussgang decomposition

% This code implements one-bit MIMO channel estimation algorithm presented
% in [cite the paper]

% For any queries, please contact R.S. Prasobh Sankar (prasobhsankar1@gmail.com)

%%%%%%% Input 
% X : unquantized signal received at BS
% S : pilot matrix
% K : number of UEs
% C_g : channel correlation 

%%%%% Output
% H_hat : estimated channel matrix (N_r \times K)


function [H_hat] = one_bit_ch_estm_blmmse(X,S,K,C_g)

[N_r N] = size(X);

R = sqrt(1/2).*sgn(X); % One bit quantized signal
r = reshape(R, N*N_r,1);

% C_g = kron(eye(L),C_G);
P = kron(transpose(S), eye(N_r));
C_y = P*C_g*P' + eye(N*N_r);

Sig_cy = diag(sqrt(1./diag(C_y)));

C_y_norm = Sig_cy*C_y*Sig_cy;
C_r = (2/pi).*( asin(real(C_y_norm)) + (1j).*asin(imag(C_y_norm)));

A_p = sqrt(2/pi).*Sig_cy;

h_hat = C_g*(A_p*P)'*inv(C_r)*r;


H_hat = reshape(h_hat, N_r, K);

end